#include "functions.inc"
#include "pearl-stand.inc"

camera {
  location  <0.0, 2, -3.0>
  //location  <0.0, 1.55, -1.2>
  look_at   <0.0, 1.0,  0.0>
  right     x*image_width/image_height
}             

light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <20, 0, 0> <0, 0, 20> // lights spread out across this distance (x * z)
  20, 20                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <40, 80, -40>   // <x y z> position of light
}

object { pearlstand }

plane {
  y,0
  pigment { color rgb <0.9,0.9,1.0> }
}
plane {
  z,3
  pigment { color rgb <0.9,0.9,1.0> }
  rotate <0,45,0>
}
plane {
  z,3
  pigment { color rgb <0.9,0.9,1.0> }
  rotate <0,-45,0>
}


  